/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy;

import edu.princeton.swing.AbstractAction2;
import edu.princeton.swing.ActionedUndoManager;
import edu.princeton.swing.ClipboardTargetManager;
import edu.princeton.swing.ExtensionFileFilter;
import edu.princeton.swing.PHighlightedTextArea;
import edu.princeton.swing.PHyperlink;
import edu.princeton.swing.PList;
import edu.princeton.swing.PScrollablePanel;
import edu.princeton.swing.PTextField;
import edu.princeton.swing.PWrappedList;
import edu.princeton.swing.text.HighlightedDocument;
import edu.princeton.toy.TCorePane;
import edu.princeton.toy.TExampleDialog;
import edu.princeton.toy.TImageManager;
import edu.princeton.toy.TMain;
import edu.princeton.toy.TOptionsFrame;
import edu.princeton.toy.TProgramDocument;
import edu.princeton.toy.TReferencePane;
import edu.princeton.toy.TSimDetailPane;
import edu.princeton.toy.TSimMachinePane;
import edu.princeton.toy.TSimMemPane;
import edu.princeton.toy.TSimStdin2Pane;
import edu.princeton.toy.TSimStdinPane;
import edu.princeton.toy.TSimStdout2Pane;
import edu.princeton.toy.TSimStdoutPane;
import edu.princeton.toy.TStdinPane;
import edu.princeton.toy.TStdoutPane;
import edu.princeton.toy.lang.TExceptionHandler;
import edu.princeton.toy.lang.TVirtualMachine;
import edu.princeton.toy.lang.TWord;
import edu.princeton.toy.lang.TWordBuffer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TFrame
extends JFrame
implements ActionListener,
ChangeListener,
TextListener,
ListSelectionListener,
TVirtualMachine.ExecutionController {
    private static final String CLASS_STRING = TFrame.class.toString();
    public static final int CASCADE_X = 24;
    public static final int CASCADE_Y = 24;
    public static final String NEW_COMMAND = CLASS_STRING + "#newCommand";
    public static final String OPEN_COMMAND = CLASS_STRING + "#openCommand";
    public static final String OPEN_EXAMPLE_COMMAND = CLASS_STRING + "#openExampleCommand";
    public static final String CLOSE_COMMAND = CLASS_STRING + "#closeCommand";
    public static final String REVERT_COMMAND = CLASS_STRING + "#revertCommand";
    public static final String SAVE_COMMAND = CLASS_STRING + "#saveCommand";
    public static final String SAVE_AS_COMMAND = CLASS_STRING + "#saveAsCommand";
    public static final String QUIT_COMMAND = CLASS_STRING + "#quitCommand";
    public static final String EDIT_MODE_COMMAND = CLASS_STRING + "#editModeCommand";
    public static final String DEBUG_MODE_COMMAND = CLASS_STRING + "#debugModeCommand";
    public static final String SIM_MODE_COMMAND = CLASS_STRING + "#simModeCommand";
    public static final String LOOK_COMMAND = CLASS_STRING + "#lookCommand";
    public static final String LOAD_COMMAND = CLASS_STRING + "#loadCommand";
    public static final String RESET_COMMAND = CLASS_STRING + "#resetCommand";
    public static final String STEP_COMMAND = CLASS_STRING + "#stepCommand";
    public static final String RUN_COMMAND = CLASS_STRING + "#runCommand";
    public static final String INTERRUPT_COMMAND = CLASS_STRING + "#interruptCommand";
    public static final String ENTER_COMMAND = CLASS_STRING + "#enterCommand";
    public static final String OPEN_STDIN_COMMAND = CLASS_STRING + "#openStdinCommand";
    public static final String SAVE_STDIN_COMMAND = CLASS_STRING + "#saveStdinCommand";
    public static final String SAVE_STDOUT_COMMAND = CLASS_STRING + "#saveStdoutCommand";
    public static final String SAVE_MEM_DUMP_COMMAND = CLASS_STRING + "#saveMemDumpCommand";
    public static final String SAVE_CORE_DUMP_COMMAND = CLASS_STRING + "#saveCoreDumpCommand";
    public static final String WORKSPACE_COMMAND = CLASS_STRING + "#workspaceCommand";
    public static final String CHECK_SYNTAX_COMMAND = CLASS_STRING + "#checkSyntaxCommand";
    public static final String FUNCTION_COMMAND = CLASS_STRING + "#functionCommand";
    public static final String CHANGE_EXECUTION_COMMAND = CLASS_STRING + "#changeExecutionCommand";
    public static final String CLEAR_ODOMETER_COMMAND = CLASS_STRING + "#clearOdometerCommand";
    public static final String CHANGE_CHECKING_COMMAND = CLASS_STRING + "#changeCheckingCommand";
    public static final String HIDE_WARNINGS_COMMAND = CLASS_STRING + "#hideWarningsCommand";
    private static final List FRAMES = new ArrayList();
    private static Object[] FRAMES_ARRAY = new Object[20];
    private static final Runner RUNNER = new Runner();
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    private static final ExtensionFileFilter TOY_FILE_FILTER = new ExtensionFileFilter("toy", "Toy Program File");
    private static final ExtensionFileFilter TXT_FILE_FILTER = new ExtensionFileFilter("txt", "Text File");
    private static final ListModel BLANK_LIST_MODEL = new DefaultListModel();
    private static final Border PADDING_BORDER = new EmptyBorder(2, 2, 2, 2);
    private TFrameAction newAction;
    private TFrameAction openAction;
    private TFrameAction openExampleAction;
    private TFrameAction closeAction;
    private TFrameAction revertAction;
    private TFrameAction saveAction;
    private TFrameAction saveAsAction;
    private TFrameAction saveAllAction;
    private TFrameAction quitAction;
    private TFrameAction editModeAction;
    private TFrameAction debugModeAction;
    private TFrameAction simModeAction;
    private TFrameAction lookAction;
    private TFrameAction loadAction;
    private TFrameAction resetAction;
    private TFrameAction stepAction;
    private TFrameAction runAction;
    private TFrameAction interruptAction;
    private TFrameAction enterAction;
    private TFrameAction openStdinAction;
    private TFrameAction saveStdinAction;
    private TFrameAction saveStdoutAction;
    private TFrameAction saveMemDumpAction;
    private TFrameAction saveCoreDumpAction;
    private TFrameAction checkSyntaxAction;
    private TFrameAction functionAction;
    private boolean isNew;
    private TProgramDocument program;
    private boolean programChanged;
    private String oldTitle;
    private boolean wasSaved;
    private File file;
    private String savedText;
    private ArrayList warningSelectionDots;
    private ArrayList warningSelectionMarks;
    private boolean hasFatalError;
    private TVirtualMachine virtualMachine;
    private TWordBuffer tempBuffer;
    private ActionedUndoManager undoManager;
    private TProgramDocument.WarningInfoStruct previousWarnings;
    private TProgramDocument.WarningInfoStruct currentWarnings;
    private String mode;
    private ButtonModel menuEditModeButtonModel;
    private ButtonModel menuDebugModeButtonModel;
    private ButtonModel menuSimModeButtonModel;
    private ButtonGroup menuModeButtonGroup;
    private JMenu workspaceMenu;
    private int workspaceIndex;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JSplitPane editPane;
    private JSplitPane leftEditPane;
    private JPanel bottomLeftEditPane;
    private PHighlightedTextArea editTextArea;
    private TReferencePane editReferencePane;
    private TStdinPane editStdinPane;
    private PScrollablePanel warningListPanel;
    private PWrappedList warningList;
    private PList warningTallyList;
    private JSplitPane debugPane;
    private PHighlightedTextArea debugTextArea;
    private Object odometerLock;
    private PTextField stepsTakenTextField;
    private int stepsTaken;
    private PTextField elapsedTimeTextField;
    private int elapsedTime;
    private JTabbedPane rightDebugPane;
    private TReferencePane debugReferencePane;
    private TStdinPane debugStdinPane;
    private TStdoutPane debugStdoutPane;
    private TCorePane debugCorePane;
    private JSplitPane simPane;
    private JSplitPane leftSimPane;
    private TSimMachinePane simMachinePane;
    private TSimDetailPane simDetailPane;
    private JTabbedPane rightSimPane;
    private TSimMemPane simMemPane;
    private TSimStdinPane simStdinPane;
    private TSimStdoutPane simStdoutPane;
    private TSimStdin2Pane simStdin2Pane;
    private TSimStdout2Pane simStdout2Pane;
    private JPanel simPanel;

    public TFrame() {
        this(new TProgramDocument(), null);
        this.isNew = true;
    }

    public TFrame(TProgramDocument program) {
        this(program, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFrame(TProgramDocument program, File file) {
        if (program == null) {
            throw new NullPointerException();
        }
        this.isNew = false;
        this.wasSaved = false;
        this.file = file;
        this.savedText = program.getText();
        this.warningSelectionDots = new ArrayList();
        this.warningSelectionMarks = new ArrayList();
        this.program = program;
        program.addTextListener(this);
        this.mode = EDIT_MODE_COMMAND;
        this.previousWarnings = new TProgramDocument.WarningInfoStruct();
        this.currentWarnings = new TProgramDocument.WarningInfoStruct();
        this.virtualMachine = new TVirtualMachine();
        program.reset(this.virtualMachine);
        this.virtualMachine.addChangeListener(this);
        this.tempBuffer = new TWordBuffer();
        this.odometerLock = new Object();
        this.stepsTaken = 0;
        this.elapsedTime = 0;
        this.setIconImage(TMain.getFrameIcon());
        this.undoManager = new ActionedUndoManager();
        program.addUndoableEditListener(this.undoManager);
        int menuShortcutKeyMask = TOOLKIT.getMenuShortcutKeyMask();
        this.newAction = new TFrameAction("New", TImageManager.getIcon((byte)1, (short)2), 78, KeyStroke.getKeyStroke(78, menuShortcutKeyMask), NEW_COMMAND);
        this.openAction = new TFrameAction("Open...", TImageManager.getIcon((byte)1, (short)3), 79, KeyStroke.getKeyStroke(79, menuShortcutKeyMask), OPEN_COMMAND);
        this.openExampleAction = new TFrameAction("Open Example Program...", TImageManager.getIcon((byte)1, (short)4), 69, KeyStroke.getKeyStroke(69, menuShortcutKeyMask), OPEN_EXAMPLE_COMMAND);
        this.closeAction = new TFrameAction("Close", null, 67, null, CLOSE_COMMAND);
        this.revertAction = new TFrameAction("Revert", null, 82, null, REVERT_COMMAND);
        this.saveAction = new TFrameAction("Save", TImageManager.getIcon((byte)1, (short)5), 83, KeyStroke.getKeyStroke(83, menuShortcutKeyMask), SAVE_COMMAND);
        this.saveAsAction = new TFrameAction("Save As...", TImageManager.getIcon((byte)1, (short)6), 83, KeyStroke.getKeyStroke(83, menuShortcutKeyMask | 1), SAVE_AS_COMMAND);
        this.quitAction = new TFrameAction("Quit", null, 81, KeyStroke.getKeyStroke(81, menuShortcutKeyMask), QUIT_COMMAND);
        this.editModeAction = new TFrameAction("Edit Mode", TImageManager.getIcon((byte)1, (short)9), 69, null, EDIT_MODE_COMMAND);
        this.debugModeAction = new TFrameAction("Debug Mode", TImageManager.getIcon((byte)1, (short)10), 68, null, DEBUG_MODE_COMMAND);
        this.simModeAction = new TFrameAction("Sim Mode", TImageManager.getIcon((byte)1, (short)12), 83, null, SIM_MODE_COMMAND);
        this.lookAction = new TFrameAction("Look", null, 76, null, LOOK_COMMAND);
        this.lookAction.setEnabled(false);
        this.loadAction = new TFrameAction("Load", null, 76, null, LOAD_COMMAND);
        this.loadAction.setEnabled(false);
        this.resetAction = new TFrameAction("Reset", TImageManager.getIcon((byte)1, (short)14), 82, null, RESET_COMMAND);
        this.resetAction.setEnabled(false);
        this.stepAction = new TFrameAction("Step", TImageManager.getIcon((byte)1, (short)15), 83, null, STEP_COMMAND);
        this.stepAction.setEnabled(false);
        this.runAction = new TFrameAction("Run", TImageManager.getIcon((byte)1, (short)16), 82, null, RUN_COMMAND);
        this.runAction.setEnabled(false);
        this.interruptAction = new TFrameAction("Interrupt", TImageManager.getIcon((byte)1, (short)17), 73, null, INTERRUPT_COMMAND);
        this.interruptAction.setEnabled(false);
        this.enterAction = new TFrameAction("Enter", null, 69, null, ENTER_COMMAND);
        this.enterAction.setEnabled(false);
        this.openStdinAction = new TFrameAction("Load File to Stdin...", null, 76, null, OPEN_STDIN_COMMAND);
        this.saveStdinAction = new TFrameAction("Save Stdin to File...", null, 73, null, SAVE_STDIN_COMMAND);
        this.saveStdoutAction = new TFrameAction("Save Stdout to File...", null, 79, null, SAVE_STDOUT_COMMAND);
        this.saveStdoutAction.setEnabled(false);
        this.saveMemDumpAction = new TFrameAction("Save Memory Dump to File...", null, 77, null, SAVE_MEM_DUMP_COMMAND);
        this.saveMemDumpAction.setEnabled(false);
        this.saveCoreDumpAction = new TFrameAction("Save Core to File...", null, 67, null, SAVE_CORE_DUMP_COMMAND);
        this.saveCoreDumpAction.setEnabled(false);
        this.checkSyntaxAction = new TFrameAction("Check Syntax", TImageManager.getIcon((byte)1, (short)18), 67, KeyStroke.getKeyStroke(67, menuShortcutKeyMask | 1), CHECK_SYNTAX_COMMAND, Boolean.TRUE);
        this.functionAction = new TFrameAction("Insert Function Comment", null, 70, KeyStroke.getKeyStroke(70, menuShortcutKeyMask), FUNCTION_COMMAND);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        menu.add(this.newAction.createMenuItem());
        menu.add(this.openAction.createMenuItem());
        menu.add(this.openExampleAction.createMenuItem());
        menu.add(this.closeAction.createMenuItem());
        menu.add(this.revertAction.createMenuItem());
        menu.addSeparator();
        menu.add(this.saveAction.createMenuItem());
        menu.add(this.saveAsAction.createMenuItem());
        menu.addSeparator();
        for (int ctr = 0; ctr < 6; ++ctr) {
            JMenuItem menuItem = TOptionsFrame.FILE_HISTORY_ACTIONS[ctr].createMenuItem();
            menu.add(menuItem);
        }
        menu.addSeparator();
        menu.add(this.quitAction.createMenuItem());
        menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menuBar.add(menu);
        menu.add(this.undoManager.getUndoAction().createMenuItem());
        menu.add(this.undoManager.getRedoAction().createMenuItem());
        menu.addSeparator();
        menu.add(ClipboardTargetManager.CUT_ACTION.createMenuItem());
        menu.add(ClipboardTargetManager.COPY_ACTION.createMenuItem());
        menu.add(ClipboardTargetManager.PASTE_ACTION.createMenuItem());
        menu.addSeparator();
        menu.add(ClipboardTargetManager.SELECT_ALL_ACTION.createMenuItem());
        menu = new JMenu("Mode");
        menu.setMnemonic(77);
        menuBar.add(menu);
        this.menuModeButtonGroup = new ButtonGroup();
        JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem(this.editModeAction);
        rbMenuItem.setAccelerator(this.editModeAction.getAccelerator());
        rbMenuItem.setSelected(true);
        this.menuEditModeButtonModel = rbMenuItem.getModel();
        this.menuModeButtonGroup.add(rbMenuItem);
        menu.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(this.debugModeAction);
        rbMenuItem.setAccelerator(this.debugModeAction.getAccelerator());
        this.menuDebugModeButtonModel = rbMenuItem.getModel();
        this.menuModeButtonGroup.add(rbMenuItem);
        menu.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem(this.simModeAction);
        rbMenuItem.setAccelerator(this.simModeAction.getAccelerator());
        this.menuSimModeButtonModel = rbMenuItem.getModel();
        this.menuModeButtonGroup.add(rbMenuItem);
        menu.add(rbMenuItem);
        menu.addSeparator();
        menu.add(this.resetAction.createMenuItem());
        menu.add(this.stepAction.createMenuItem());
        menu.add(this.runAction.createMenuItem());
        menu.add(this.interruptAction.createMenuItem());
        menu.addSeparator();
        menu.add(this.openStdinAction.createMenuItem());
        menu.add(this.saveStdinAction.createMenuItem());
        menu.add(this.saveStdoutAction.createMenuItem());
        menu.add(this.saveMemDumpAction.createMenuItem());
        menu.add(this.saveCoreDumpAction.createMenuItem());
        menu = new JMenu("Workspace");
        menu.setMnemonic(87);
        menuBar.add(menu);
        this.workspaceMenu = menu;
        menu = new JMenu("Tools");
        menu.setMnemonic(84);
        menuBar.add(menu);
        menu.add(this.checkSyntaxAction.createMenuItem());
        menu.add(this.functionAction.createMenuItem());
        menu.addSeparator();
        menu.add(TOptionsFrame.OPTIONS_ACTION.createMenuItem());
        this.getContentPane().setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.newAction).setToolTipText("New");
        toolbar.add(this.openAction).setToolTipText("Open...");
        toolbar.add(this.openExampleAction).setToolTipText("Open Example...");
        toolbar.add(this.saveAction).setToolTipText("Save");
        toolbar.add(this.saveAsAction).setToolTipText("Save As...");
        toolbar.addSeparator();
        toolbar.add(ClipboardTargetManager.CUT_ACTION).setToolTipText("Cut");
        toolbar.add(ClipboardTargetManager.COPY_ACTION).setToolTipText("Copy");
        toolbar.add(ClipboardTargetManager.PASTE_ACTION).setToolTipText("Paste");
        toolbar.add(ClipboardTargetManager.SELECT_ALL_ACTION).setToolTipText("Select All");
        toolbar.addSeparator();
        toolbar.add(this.undoManager.getUndoAction()).setToolTipText("Undo");
        toolbar.add(this.undoManager.getRedoAction()).setToolTipText("Redo");
        toolbar.addSeparator();
        toolbar.add(this.editModeAction).setToolTipText("Edit Mode");
        toolbar.add(this.debugModeAction).setToolTipText("Debug Mode");
        toolbar.add(this.simModeAction).setToolTipText("Sim Mode");
        toolbar.addSeparator();
        toolbar.add(this.checkSyntaxAction).setToolTipText("Check Syntax");
        this.getContentPane().add((Component)toolbar, "North");
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.editPane = new JSplitPane(1);
        this.leftEditPane = new JSplitPane(0);
        if (this.leftEditPane.getBorder() == null) {
            this.leftEditPane.setBorder(PADDING_BORDER);
        } else {
            this.leftEditPane.setBorder(new CompoundBorder(PADDING_BORDER, this.leftEditPane.getBorder()));
        }
        this.editTextArea = new PHighlightedTextArea(program, 25, 82);
        TOptionsFrame.registerComponent(this.editTextArea, 0);
        TOptionsFrame.registerHighlightedTextArea(this.editTextArea);
        int[] columnMarkers = new int[]{8, 41, 80};
        this.editTextArea.setColumnMarkers(columnMarkers);
        JPopupMenu popupMenu = this.editTextArea.getPopupMenu();
        popupMenu.removeAll();
        popupMenu.add(this.undoManager.getUndoAction().createMenuItem());
        popupMenu.add(this.undoManager.getRedoAction().createMenuItem());
        popupMenu.addSeparator();
        popupMenu.add(ClipboardTargetManager.CUT_ACTION.createMenuItem());
        popupMenu.add(ClipboardTargetManager.COPY_ACTION.createMenuItem());
        popupMenu.add(ClipboardTargetManager.PASTE_ACTION.createMenuItem());
        popupMenu.addSeparator();
        popupMenu.add(ClipboardTargetManager.SELECT_ALL_ACTION.createMenuItem());
        popupMenu.addSeparator();
        popupMenu.add(this.checkSyntaxAction.createMenuItem());
        popupMenu.add(this.functionAction.createMenuItem());
        this.leftEditPane.setTopComponent(this.editTextArea);
        this.bottomLeftEditPane = new JPanel(new GridBagLayout());
        this.bottomLeftEditPane.add((Component)new JLabel("Warnings"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        PHyperlink hyperlink = new PHyperlink("Change Settings...", null, 3);
        hyperlink.setActionCommand(CHANGE_CHECKING_COMMAND);
        hyperlink.addActionListener(this);
        this.bottomLeftEditPane.add((Component)hyperlink, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        hyperlink = new PHyperlink("Hide Warnings", null, 3);
        hyperlink.setActionCommand(HIDE_WARNINGS_COMMAND);
        hyperlink.addActionListener(this);
        this.bottomLeftEditPane.add((Component)hyperlink, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.warningListPanel = new PScrollablePanel(new GridBagLayout());
        this.warningListPanel.setFont(null);
        this.warningListPanel.setWidthTrackingPolicy((byte)2);
        TOptionsFrame.registerComponent(this.warningListPanel, 1);
        this.warningList = new PWrappedList();
        this.warningList.setFont(null);
        this.warningList.setVisibleRowCount(10);
        this.warningList.addListSelectionListener(this);
        this.warningListPanel.add((Component)this.warningList, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.warningTallyList = new PWrappedList();
        this.warningTallyList.setFont(null);
        this.warningTallyList.setEnabled(false);
        this.warningListPanel.add((Component)this.warningTallyList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.bottomLeftEditPane.add((Component)new JScrollPane(this.warningListPanel, 22, 31), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.leftEditPane.setBottomComponent(this.bottomLeftEditPane);
        this.leftEditPane.setOneTouchExpandable(true);
        this.leftEditPane.setResizeWeight(0.8);
        this.editPane.setLeftComponent(this.leftEditPane);
        JTabbedPane rightEditPane = new JTabbedPane(1);
        this.editReferencePane = new TReferencePane();
        TOptionsFrame.registerComponent(this.editReferencePane, 2);
        rightEditPane.addTab("Reference", this.editReferencePane);
        this.editStdinPane = new TStdinPane(this.virtualMachine, this.openStdinAction, this.saveStdinAction, false);
        TOptionsFrame.registerComponent(this.editStdinPane, 3);
        rightEditPane.addTab("Stdin", this.editStdinPane);
        this.editPane.setRightComponent(rightEditPane);
        this.editPane.setOneTouchExpandable(true);
        this.editPane.setResizeWeight(0.9);
        this.cardPanel.add((Component)this.editPane, EDIT_MODE_COMMAND);
        this.debugPane = new JSplitPane(1);
        JPanel debugLeftPane = new JPanel(new GridBagLayout());
        this.debugTextArea = new PHighlightedTextArea(program, 25, 82);
        TOptionsFrame.registerComponent(this.debugTextArea, 0);
        TOptionsFrame.registerHighlightedTextArea(this.debugTextArea);
        this.debugTextArea.setEditable(false);
        int[] columnMarkers2 = new int[]{8, 41, 80};
        this.debugTextArea.setColumnMarkers(columnMarkers2);
        debugLeftPane.add((Component)this.debugTextArea, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel statsPanel = new JPanel(new GridBagLayout());
        statsPanel.add((Component)new JLabel("Steps Taken"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.stepsTakenTextField = new PTextField(12);
        this.stepsTakenTextField.setEditable(false);
        this.stepsTakenTextField.setBackground(null);
        this.stepsTakenTextField.setDisabledTextColor(Color.black);
        this.stepsTakenTextField.setText("0");
        this.stepsTakenTextField.setMinimumSize(this.stepsTakenTextField.getPreferredSize());
        statsPanel.add((Component)this.stepsTakenTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        PHyperlink hyperlink2 = new PHyperlink("Clear", null, 3);
        hyperlink2.setActionCommand(CLEAR_ODOMETER_COMMAND);
        hyperlink2.addActionListener(this);
        statsPanel.add((Component)hyperlink2, new GridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        statsPanel.add((Component)new JLabel("Elapsed Time"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.elapsedTimeTextField = new PTextField(12);
        this.elapsedTimeTextField.setEditable(false);
        this.elapsedTimeTextField.setBackground(null);
        this.elapsedTimeTextField.setDisabledTextColor(Color.black);
        this.elapsedTimeTextField.setText("0.000 s");
        this.elapsedTimeTextField.setMinimumSize(this.elapsedTimeTextField.getPreferredSize());
        statsPanel.add((Component)this.elapsedTimeTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        statsPanel.add((Component)new JLabel("Refresh Rate"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        JTextField textField = new JTextField(12);
        textField.setEnabled(false);
        textField.setBackground(null);
        textField.setDisabledTextColor(Color.black);
        textField.setDocument(TOptionsFrame.getRefreshRateDocument());
        textField.setMinimumSize(textField.getPreferredSize());
        statsPanel.add((Component)textField, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        hyperlink2 = new PHyperlink("Change Settings...", null, 3);
        hyperlink2.setActionCommand(CHANGE_EXECUTION_COMMAND);
        hyperlink2.addActionListener(this);
        statsPanel.add((Component)hyperlink2, new GridBagConstraints(2, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        statsPanel.add((Component)new JLabel("Target Clock Period"), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        textField = new JTextField(12);
        textField.setEnabled(false);
        textField.setBackground(null);
        textField.setDisabledTextColor(Color.black);
        textField.setDocument(TOptionsFrame.getClockPeriodDocument());
        textField.setMinimumSize(textField.getPreferredSize());
        statsPanel.add((Component)textField, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        debugLeftPane.add((Component)statsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 2, 2, 2), 0, 0));
        JPanel buttonPanel = new JPanel(new GridLayout(2, 2, 4, 4));
        buttonPanel.add(new JButton(this.stepAction));
        buttonPanel.add(new JButton(this.runAction));
        buttonPanel.add(new JButton(this.resetAction));
        buttonPanel.add(new JButton(this.interruptAction));
        debugLeftPane.add((Component)buttonPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.debugPane.setLeftComponent(debugLeftPane);
        this.rightDebugPane = new JTabbedPane(1);
        this.debugReferencePane = new TReferencePane();
        TOptionsFrame.registerComponent(this.debugReferencePane, 2);
        this.rightDebugPane.addTab("Reference", this.debugReferencePane);
        this.debugStdinPane = new TStdinPane(this.virtualMachine, this.openStdinAction, this.saveStdinAction, true);
        TOptionsFrame.registerComponent(this.debugStdinPane, 3);
        this.rightDebugPane.addTab("Stdin", this.debugStdinPane);
        this.debugStdoutPane = new TStdoutPane(this.virtualMachine, this.saveStdoutAction);
        TOptionsFrame.registerComponent(this.debugStdoutPane, 4);
        this.rightDebugPane.addTab("Stdout", this.debugStdoutPane);
        this.debugCorePane = new TCorePane(this.virtualMachine, this.saveMemDumpAction, this.saveCoreDumpAction);
        TOptionsFrame.registerComponent(this.debugCorePane, 5);
        this.rightDebugPane.addTab("Core", this.debugCorePane);
        this.debugPane.setRightComponent(this.rightDebugPane);
        this.debugPane.setOneTouchExpandable(true);
        this.debugPane.setResizeWeight(0.9);
        this.cardPanel.add((Component)this.debugPane, DEBUG_MODE_COMMAND);
        this.simPane = new JSplitPane(1);
        this.leftSimPane = new JSplitPane(0);
        this.simMachinePane = new TSimMachinePane(this.virtualMachine, this.loadAction, this.lookAction, this.stepAction, this.runAction, this.enterAction, this.interruptAction, this.resetAction);
        this.leftSimPane.setTopComponent(this.simMachinePane);
        this.simDetailPane = new TSimDetailPane(this.virtualMachine, this.simMachinePane);
        this.leftSimPane.setBottomComponent(this.simDetailPane);
        int machinePanePreferredHeight = this.simMachinePane.getPreferredSize().height;
        int detailPanePreferredHeight = this.simDetailPane.getPreferredSize().height;
        this.leftSimPane.setOneTouchExpandable(true);
        this.leftSimPane.setResizeWeight((float)machinePanePreferredHeight / (float)(machinePanePreferredHeight + detailPanePreferredHeight));
        this.simPane.setLeftComponent(this.leftSimPane);
        this.rightSimPane = new JTabbedPane(1);
        this.simMemPane = new TSimMemPane(this.virtualMachine);
        this.rightSimPane.add((Component)new JScrollPane(this.simMemPane, 21, 32), "Memory");
        this.simStdinPane = new TSimStdinPane(this.virtualMachine);
        this.rightSimPane.add((Component)new JScrollPane(this.simStdinPane, 21, 32), "Stdin");
        this.simStdoutPane = new TSimStdoutPane(this.virtualMachine);
        this.rightSimPane.add((Component)new JScrollPane(this.simStdoutPane, 21, 32), "Stdout");
        this.simStdin2Pane = new TSimStdin2Pane(this.virtualMachine);
        this.rightSimPane.add((Component)new JScrollPane(this.simStdin2Pane, 21, 32), "Stdin'");
        this.simStdout2Pane = new TSimStdout2Pane(this.virtualMachine);
        this.rightSimPane.add((Component)new JScrollPane(this.simStdout2Pane, 21, 32), "Stdout'");
        this.simPane.setRightComponent(this.rightSimPane);
        this.simPane.setOneTouchExpandable(true);
        this.simPane.setResizeWeight(0.9);
        this.cardPanel.add((Component)this.simPane, SIM_MODE_COMMAND);
        this.getContentPane().add((Component)this.cardPanel, "Center");
        this.setDefaultCloseOperation(0);
        List list = FRAMES;
        synchronized (list) {
            FRAMES.add(this);
            this.updateTitle();
        }
        this.enableEvents(64L);
        this.doCommand(CHECK_SYNTAX_COMMAND, Boolean.FALSE);
        this.pack();
    }

    @Override
    public void dispose() {
        this.doCommand(CLOSE_COMMAND, null);
    }

    private void updateTitle() {
        String newTitle;
        if (this.file != null) {
            this.program.setTitle(this.file.getName());
        }
        boolean titleChanged = !(newTitle = this.program.getTitle()).equals(this.oldTitle);
        boolean isSaved = this.program.getText().equals(this.savedText);
        if (titleChanged || isSaved != this.wasSaved) {
            if (isSaved) {
                this.setTitle(newTitle + " - Visual X-TOY");
            } else {
                this.setTitle(newTitle + "* - Visual X-TOY");
            }
        }
        if (titleChanged) {
            TFrame.updateAllWorkspaceMenus();
        }
        this.oldTitle = new String(newTitle);
        this.wasSaved = isSaved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAllWorkspaceMenus() {
        List list = FRAMES;
        synchronized (list) {
            int frameCtr;
            int length = FRAMES.size();
            Object[] framesArray = FRAMES_ARRAY = FRAMES.toArray(FRAMES_ARRAY);
            String[] titles = new String[length];
            for (frameCtr = 0; frameCtr < length; ++frameCtr) {
                titles[frameCtr] = ((TFrame)framesArray[frameCtr]).program.getTitle();
            }
            for (frameCtr = 0; frameCtr < length; ++frameCtr) {
                WorkspaceMenuItem menuItem;
                int ctr;
                TFrame frame = (TFrame)framesArray[frameCtr];
                JMenu menu = frame.workspaceMenu;
                int menuItemCount = frame.workspaceMenu.getItemCount();
                frame.workspaceIndex = frameCtr;
                for (ctr = menuItemCount; ctr < length; ++ctr) {
                    menuItem = new WorkspaceMenuItem(ctr);
                    menuItem.setActionCommand(WORKSPACE_COMMAND);
                    menuItem.addActionListener(frame);
                    menu.add(menuItem);
                }
                for (ctr = menuItemCount; ctr > length; --ctr) {
                    menu.remove(ctr - 1);
                }
                for (ctr = 0; ctr < length; ++ctr) {
                    menuItem = (WorkspaceMenuItem)menu.getItem(ctr);
                    menuItem.setText(titles[ctr]);
                    menuItem.getModel().setSelected(ctr == frameCtr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAutoCheck(boolean autoCheck) {
        Runner runner = RUNNER;
        synchronized (runner) {
            if (autoCheck) {
                if (TFrame.RUNNER.runningThread == null) {
                    TFrame.RUNNER.runningThread = new Thread(RUNNER);
                    TFrame.RUNNER.runningThread.start();
                }
            } else {
                TFrame.RUNNER.runningThread = null;
            }
        }
    }

    public static TFrame createInitialFrame() {
        TFrame frame = new TFrame();
        frame.setBounds(TOptionsFrame.getLastFrameBounds());
        frame.validate();
        frame.simPane.setDividerLocation(TOptionsFrame.getLastVerticalDividerLocation());
        frame.leftSimPane.setDividerLocation(TOptionsFrame.getLastSimHorizontalDividerLocation());
        frame.editPane.setDividerLocation(TOptionsFrame.getLastVerticalDividerLocation());
        frame.leftEditPane.setDividerLocation(TOptionsFrame.getLastEditHorizontalDividerLocation());
        frame.validate();
        frame.doCommand(EDIT_MODE_COMMAND, null);
        frame.setVisible(true);
        frame.requestFocus();
        frame.toFront();
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doCommand(String command, Object extraInfo) {
        if (command == NEW_COMMAND) {
            int x = this.getX();
            int y = this.getY();
            int width = this.getWidth();
            int height = this.getHeight();
            Dimension screenSize = TOOLKIT.getScreenSize();
            if (width + 72 < screenSize.width && height + 72 < screenSize.height && ((x += 24) + width > screenSize.width || (y += 24) + height > screenSize.height)) {
                x = 0;
                y = 0;
            }
            TFrame frame = new TFrame();
            frame.setBounds(x, y, width, height);
            int dividerLocation = this.mode == EDIT_MODE_COMMAND ? this.editPane.getDividerLocation() : (this.mode == DEBUG_MODE_COMMAND ? this.debugPane.getDividerLocation() : this.simPane.getDividerLocation());
            frame.validate();
            frame.simPane.setDividerLocation(dividerLocation);
            frame.leftSimPane.setDividerLocation(this.leftSimPane.getDividerLocation());
            frame.editPane.setDividerLocation(dividerLocation);
            frame.leftEditPane.setDividerLocation(this.leftEditPane.getDividerLocation());
            frame.validate();
            frame.setVisible(true);
            frame.requestFocus();
            frame.toFront();
            return true;
        }
        if (command == OPEN_COMMAND) {
            File[] files;
            if (extraInfo == null) {
                JFileChooser chooser = new JFileChooser();
                File currentDirectory = TOptionsFrame.getCurrentDirectory();
                if (currentDirectory != null) {
                    chooser.setCurrentDirectory(currentDirectory);
                }
                chooser.setAcceptAllFileFilterUsed(true);
                chooser.addChoosableFileFilter(TOY_FILE_FILTER);
                chooser.setFileHidingEnabled(true);
                chooser.setFileSelectionMode(0);
                chooser.setMultiSelectionEnabled(true);
                if (chooser.showOpenDialog(this) != 0) {
                    return false;
                }
                currentDirectory = chooser.getCurrentDirectory();
                if (currentDirectory != null) {
                    TOptionsFrame.setCurrentDirectory(currentDirectory);
                }
                files = chooser.getSelectedFiles();
            } else {
                files = new File[]{(File)extraInfo};
            }
            if (files.length == 0) {
                return false;
            }
            int x = this.getX();
            int y = this.getY();
            int width = this.getWidth();
            int height = this.getHeight();
            Dimension screenSize = TOOLKIT.getScreenSize();
            boolean cascade = width + 72 < screenSize.width && height + 72 < screenSize.height;
            for (int ctr = 0; ctr < files.length; ++ctr) {
                StringBuffer buffer = new StringBuffer();
                try {
                    int readChars;
                    FileReader fileReader = new FileReader(files[ctr]);
                    char[] array = new char[100];
                    do {
                        if ((readChars = fileReader.read(array, 0, array.length)) == -1) continue;
                        buffer.append(array, 0, readChars);
                    } while (readChars != -1);
                    fileReader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "An error occurred when reading from the file \"" + files[ctr] + "\".", "File I/O Error", 0);
                    return false;
                }
                if (files.length == 1 && !this.virtualMachine.isRunning() && this.program.getText().equals(this.savedText) || ctr == 0 && this.isNew && !this.virtualMachine.isRunning() && this.program.getText().equals(this.savedText)) {
                    String text = buffer.toString();
                    this.isNew = false;
                    this.program.setText(text);
                    this.savedText = this.program.getText();
                    this.file = files[ctr];
                    this.undoManager.discardAllEdits();
                    this.updateTitle();
                    if (this.mode == EDIT_MODE_COMMAND) {
                        this.doCommand(CHECK_SYNTAX_COMMAND, Boolean.FALSE);
                    } else {
                        this.doCommand(RESET_COMMAND, null);
                    }
                } else {
                    TProgramDocument program = new TProgramDocument(buffer.toString());
                    TFrame frame = new TFrame(program, files[ctr]);
                    if (cascade && ((x += 24) + width > screenSize.width || (y += 24) + height > screenSize.height)) {
                        x = 0;
                        y = 0;
                    }
                    frame.setBounds(x, y, width, height);
                    int dividerLocation = this.mode == EDIT_MODE_COMMAND ? this.editPane.getDividerLocation() : (this.mode == DEBUG_MODE_COMMAND ? this.debugPane.getDividerLocation() : this.simPane.getDividerLocation());
                    frame.validate();
                    frame.simPane.setDividerLocation(dividerLocation);
                    frame.leftSimPane.setDividerLocation(this.leftSimPane.getDividerLocation());
                    frame.editPane.setDividerLocation(dividerLocation);
                    frame.leftEditPane.setDividerLocation(this.leftEditPane.getDividerLocation());
                    frame.validate();
                    frame.doCommand(this.mode, null);
                    frame.setVisible(true);
                    frame.requestFocus();
                    frame.toFront();
                }
                TOptionsFrame.putFileIntoHistory(files[ctr]);
            }
            return true;
        }
        if (command == OPEN_EXAMPLE_COMMAND) {
            String[] exampleText = TExampleDialog.showExampleDialog(this);
            if (exampleText == null) {
                return false;
            }
            int x = this.getX();
            int y = this.getY();
            int width = this.getWidth();
            int height = this.getHeight();
            Dimension screenSize = TOOLKIT.getScreenSize();
            boolean cascade = width + 72 < screenSize.width && height + 72 < screenSize.height;
            for (int ctr = 0; ctr < exampleText.length; ++ctr) {
                if (exampleText.length == 1 && !this.virtualMachine.isRunning() && this.program.getText().equals(this.savedText) || ctr == 0 && this.isNew && !this.virtualMachine.isRunning() && this.program.getText().equals(this.savedText)) {
                    this.isNew = false;
                    this.program.setText(exampleText[ctr]);
                    this.savedText = this.program.getText();
                    this.file = null;
                    this.undoManager.discardAllEdits();
                    this.updateTitle();
                    if (this.mode == EDIT_MODE_COMMAND) {
                        this.doCommand(CHECK_SYNTAX_COMMAND, Boolean.FALSE);
                        continue;
                    }
                    this.doCommand(RESET_COMMAND, null);
                    continue;
                }
                TProgramDocument program = new TProgramDocument(exampleText[ctr]);
                TFrame frame = new TFrame(program, null);
                if (cascade && ((x += 24) + width > screenSize.width || (y += 24) + height > screenSize.height)) {
                    x = 0;
                    y = 0;
                }
                frame.setBounds(x, y, width, height);
                int dividerLocation = this.mode == EDIT_MODE_COMMAND ? this.editPane.getDividerLocation() : (this.mode == DEBUG_MODE_COMMAND ? this.debugPane.getDividerLocation() : this.simPane.getDividerLocation());
                frame.validate();
                frame.simPane.setDividerLocation(dividerLocation);
                frame.leftSimPane.setDividerLocation(this.leftSimPane.getDividerLocation());
                frame.editPane.setDividerLocation(dividerLocation);
                frame.leftEditPane.setDividerLocation(this.leftEditPane.getDividerLocation());
                frame.validate();
                frame.doCommand(this.mode, null);
                frame.setVisible(true);
                frame.requestFocus();
                frame.toFront();
            }
            return true;
        }
        if (command == CLOSE_COMMAND) {
            this.virtualMachine.interrupt();
            if (!this.savedText.equals(this.program.getText())) {
                boolean done = false;
                while (!done) {
                    int result = JOptionPane.showConfirmDialog(this, "The program \"" + this.program.getTitle() + "\" has been modified since it was " + "last saved.\nDo you wish to save before closing the window?", "Confirm Close Command", 1, 2);
                    if (result == 2) {
                        return false;
                    }
                    if (result == 0) {
                        done = this.doCommand(SAVE_COMMAND, null);
                        continue;
                    }
                    done = true;
                }
            }
            this.setVisible(false);
            TOptionsFrame.setLastFrameBounds(this.getBounds());
            if (this.mode == EDIT_MODE_COMMAND) {
                TOptionsFrame.setLastVerticalDividerLocation(this.editPane.getDividerLocation());
            } else if (this.mode == DEBUG_MODE_COMMAND) {
                TOptionsFrame.setLastVerticalDividerLocation(this.debugPane.getDividerLocation());
            } else {
                TOptionsFrame.setLastVerticalDividerLocation(this.simPane.getDividerLocation());
            }
            this.cardLayout.show(this.cardPanel, EDIT_MODE_COMMAND);
            TOptionsFrame.setLastEditHorizontalDividerLocation(this.leftEditPane.getDividerLocation());
            this.cardLayout.show(this.cardPanel, SIM_MODE_COMMAND);
            TOptionsFrame.setLastSimHorizontalDividerLocation(this.leftSimPane.getDividerLocation());
            TOptionsFrame.unregisterComponent(this.editTextArea, 0);
            TOptionsFrame.unregisterHighlightedTextArea(this.editTextArea);
            TOptionsFrame.unregisterComponent(this.warningListPanel, 1);
            TOptionsFrame.unregisterComponent(this.editReferencePane, 2);
            TOptionsFrame.unregisterComponent(this.editStdinPane, 3);
            TOptionsFrame.unregisterComponent(this.debugTextArea, 0);
            TOptionsFrame.unregisterHighlightedTextArea(this.debugTextArea);
            TOptionsFrame.unregisterComponent(this.debugReferencePane, 2);
            TOptionsFrame.unregisterComponent(this.debugStdinPane, 3);
            TOptionsFrame.unregisterComponent(this.debugStdoutPane, 4);
            TOptionsFrame.unregisterComponent(this.debugCorePane, 5);
            super.dispose();
            List done = FRAMES;
            synchronized (done) {
                FRAMES.remove(this);
                if (FRAMES.size() == 0) {
                    System.exit(0);
                }
                TFrame.updateAllWorkspaceMenus();
            }
            return true;
        }
        if (command == REVERT_COMMAND) {
            int result = JOptionPane.showConfirmDialog(this, "Reverting to the saved text will cause all of your changes to be lost.\nAre you sure you wish to do this?", "Confirm Revert Command", 0, 2);
            if (result == 0) {
                String newText = null;
                if (this.file != null) {
                    try {
                        int readChars;
                        FileReader fileReader = new FileReader(this.file);
                        StringBuffer buffer = new StringBuffer();
                        char[] array = new char[100];
                        do {
                            if ((readChars = fileReader.read(array, 0, array.length)) == -1) continue;
                            buffer.append(array, 0, readChars);
                        } while (readChars != -1);
                        fileReader.close();
                        newText = buffer.toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "An error occurred when reading from the file \"" + this.file + "\".\n" + "Visual X-TOY will load the saved text from its own cache.", "File I/O Error", 0);
                    }
                }
                if (newText == null) {
                    newText = this.savedText;
                }
                this.program.setText(newText);
                this.savedText = this.program.getText();
                this.updateTitle();
            }
            return true;
        }
        if (command == SAVE_COMMAND && this.file != null) {
            try {
                FileWriter fileWriter = new FileWriter(this.file);
                String text = this.program.getText();
                fileWriter.write(text);
                fileWriter.close();
                this.savedText = text;
                this.updateTitle();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred when writing to the file \"" + this.file + "\".", "File I/O Error", 0);
            }
            this.isNew = false;
            return true;
        }
        if (command == SAVE_AS_COMMAND || command == SAVE_COMMAND && this.file == null) {
            if (extraInfo == null) {
                int result;
                JFileChooser chooser = new JFileChooser();
                File currentDirectory = TOptionsFrame.getCurrentDirectory();
                if (currentDirectory != null) {
                    chooser.setCurrentDirectory(currentDirectory);
                }
                if (this.file != null) {
                    chooser.setSelectedFile(this.file);
                } else {
                    char[] array = this.program.getTitle().toCharArray();
                    boolean needsWhitespace = false;
                    StringBuffer buffer = new StringBuffer(array.length);
                    for (int ctr = 0; ctr < array.length; ++ctr) {
                        char ch = array[ctr];
                        if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '.') {
                            buffer.append(ch);
                            needsWhitespace = true;
                            continue;
                        }
                        if (ch >= 'A' && ch <= 'Z') {
                            buffer.append((char)(ch - 65 + 97));
                            needsWhitespace = true;
                            continue;
                        }
                        if (!Character.isWhitespace(ch) && ch != '_' || !needsWhitespace) continue;
                        buffer.append('_');
                        needsWhitespace = false;
                    }
                    int bufferLength = buffer.length();
                    if (!needsWhitespace && bufferLength > 0) {
                        buffer.setLength(bufferLength - 1);
                    }
                    buffer.append(".toy");
                    chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), buffer.toString()));
                }
                chooser.setAcceptAllFileFilterUsed(true);
                chooser.addChoosableFileFilter(TOY_FILE_FILTER);
                chooser.setFileHidingEnabled(true);
                chooser.setFileSelectionMode(0);
                chooser.setMultiSelectionEnabled(false);
                if (chooser.showSaveDialog(this) != 0) {
                    return false;
                }
                currentDirectory = chooser.getCurrentDirectory();
                if (currentDirectory != null) {
                    TOptionsFrame.setCurrentDirectory(currentDirectory);
                }
                this.file = chooser.getSelectedFile();
                if (this.file.exists() && (result = JOptionPane.showConfirmDialog(this, "The file \"" + this.file + "\" already exists.\n" + "Are you sure you want to save over it?", "Confirm Save As Command", 0, 2)) != 0) {
                    return false;
                }
            } else {
                this.file = (File)extraInfo;
            }
            try {
                FileWriter fileWriter = new FileWriter(this.file);
                String text = this.program.getText();
                fileWriter.write(text);
                fileWriter.close();
                this.savedText = text;
                this.updateTitle();
            }
            catch (Exception e) {
                this.file = null;
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred when writing to the file \"" + this.file + "\".", "File I/O error", 0);
            }
            this.isNew = false;
            TOptionsFrame.putFileIntoHistory(this.file);
            return true;
        }
        if (command == QUIT_COMMAND) {
            boolean abort = false;
            List text = FRAMES;
            synchronized (text) {
                while (!abort) {
                    TFrame frame = (TFrame)FRAMES.get(0);
                    if (frame.doCommand(CLOSE_COMMAND, null)) continue;
                    abort = true;
                }
            }
            return !abort;
        }
        if (command == EDIT_MODE_COMMAND) {
            if (this.mode == EDIT_MODE_COMMAND || this.virtualMachine.isRunning()) {
                return false;
            }
            this.cardLayout.show(this.cardPanel, EDIT_MODE_COMMAND);
            if (this.mode == DEBUG_MODE_COMMAND) {
                this.editPane.setDividerLocation(this.debugPane.getDividerLocation());
            } else if (this.mode == SIM_MODE_COMMAND) {
                this.editPane.setDividerLocation(this.simPane.getDividerLocation());
            }
            this.menuModeButtonGroup.setSelected(this.menuEditModeButtonModel, true);
            this.editModeAction.setSmallIcon(TImageManager.getIcon((byte)1, (short)9));
            this.debugModeAction.setSmallIcon(TImageManager.getIcon((byte)1, (short)10));
            this.simModeAction.setSmallIcon(TImageManager.getIcon((byte)1, (short)12));
            this.mode = EDIT_MODE_COMMAND;
            this.checkSyntaxAction.setEnabled(true);
            this.functionAction.setEnabled(true);
            this.doCommand(RESET_COMMAND, null);
            return true;
        }
        if (command == DEBUG_MODE_COMMAND) {
            if (this.mode == DEBUG_MODE_COMMAND || this.virtualMachine.isRunning()) {
                return false;
            }
            if (this.mode == EDIT_MODE_COMMAND) {
                this.doCommand(CHECK_SYNTAX_COMMAND, Boolean.FALSE);
                if (this.hasFatalError) {
                    JOptionPane.showMessageDialog(this, "Your program contains fatal errors.  Please correct these before\nleaving edit mode.", "Action Blocked", 0);
                    this.menuModeButtonGroup.setSelected(this.menuEditModeButtonModel, true);
                    return false;
                }
                this.program.setInitialStdin(this.virtualMachine.getUnconsumedStdin());
            }
            this.cardLayout.show(this.cardPanel, DEBUG_MODE_COMMAND);
            if (this.mode == EDIT_MODE_COMMAND) {
                this.debugPane.setDividerLocation(this.editPane.getDividerLocation());
            } else if (this.mode == SIM_MODE_COMMAND) {
                this.debugPane.setDividerLocation(this.simPane.getDividerLocation());
            }
            this.menuModeButtonGroup.setSelected(this.menuDebugModeButtonModel, true);
            this.editModeAction.setSmallIcon(TImageManager.getIcon((byte)1, (short)8));
            this.debugModeAction.setSmallIcon(TImageManager.getIcon((byte)1, (short)11));
            this.simModeAction.setSmallIcon(TImageManager.getIcon((byte)1, (short)12));
            this.mode = DEBUG_MODE_COMMAND;
            this.checkSyntaxAction.setEnabled(false);
            this.functionAction.setEnabled(false);
            this.virtualMachine.setExceptionHandler(TOptionsFrame.getExceptionHandler());
            this.doCommand(RESET_COMMAND, null);
            return true;
        }
        if (command == SIM_MODE_COMMAND) {
            if (this.mode == SIM_MODE_COMMAND || this.virtualMachine.isRunning()) {
                return false;
            }
            if (this.mode == EDIT_MODE_COMMAND) {
                this.doCommand(CHECK_SYNTAX_COMMAND, Boolean.FALSE);
                if (this.hasFatalError) {
                    JOptionPane.showMessageDialog(this, "Your program contains fatal errors.  Please correct these before\nleaving edit mode.", "Action Blocked", 0);
                    this.menuModeButtonGroup.setSelected(this.menuEditModeButtonModel, true);
                    return false;
                }
                this.program.setInitialStdin(this.virtualMachine.getUnconsumedStdin());
            }
            this.cardLayout.show(this.cardPanel, SIM_MODE_COMMAND);
            if (this.mode == EDIT_MODE_COMMAND) {
                this.simPane.setDividerLocation(this.editPane.getDividerLocation());
            } else if (this.mode == DEBUG_MODE_COMMAND) {
                this.simPane.setDividerLocation(this.debugPane.getDividerLocation());
            }
            this.menuModeButtonGroup.setSelected(this.menuSimModeButtonModel, true);
            this.editModeAction.setSmallIcon(TImageManager.getIcon((byte)1, (short)8));
            this.debugModeAction.setSmallIcon(TImageManager.getIcon((byte)1, (short)10));
            this.simModeAction.setSmallIcon(TImageManager.getIcon((byte)1, (short)13));
            this.mode = SIM_MODE_COMMAND;
            this.checkSyntaxAction.setEnabled(false);
            this.functionAction.setEnabled(false);
            this.virtualMachine.setExceptionHandler(TExceptionHandler.PROMISCUOUS_EXCEPTION_HANDLER);
            this.doCommand(RESET_COMMAND, null);
            return true;
        }
        if (command == WORKSPACE_COMMAND) {
            block186: {
                try {
                    int index = (Integer)extraInfo;
                    if (index == this.workspaceIndex) break block186;
                    JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)this.workspaceMenu.getItem(index);
                    menuItem.getModel().setSelected(false);
                    List frame = FRAMES;
                    synchronized (frame) {
                        TFrame frame2 = (TFrame)FRAMES.get(index);
                        frame2.requestFocus();
                        frame2.toFront();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }
        if (command == CHECK_SYNTAX_COMMAND) {
            int ctr;
            long startTime = System.currentTimeMillis();
            this.programChanged = false;
            TProgramDocument.WarningInfoStruct tempWarningInfo = this.previousWarnings;
            this.previousWarnings = this.currentWarnings;
            this.currentWarnings = tempWarningInfo;
            this.program.getWarnings(this.currentWarnings, TOptionsFrame.getIgnoreWarnings());
            this.hasFatalError = this.currentWarnings.hasFatalError;
            int length = this.currentWarnings.warningCount;
            DefaultListModel model = null;
            if (this.warningList.getModel() instanceof DefaultListModel) {
                if (!this.previousWarnings.warningsEqual(this.currentWarnings)) {
                    model = (DefaultListModel)this.warningList.getModel();
                    this.warningList.setModel(BLANK_LIST_MODEL);
                    model.clear();
                }
            } else {
                model = new DefaultListModel();
            }
            if (model != null) {
                model.ensureCapacity(length);
                for (ctr = 0; ctr < length; ++ctr) {
                    model.addElement(this.currentWarnings.warnings[ctr]);
                }
                this.warningList.setModel(model);
            }
            if (this.warningSelectionDots.size() > 0) {
                int end = Math.min(length, this.warningSelectionDots.size());
                Iterator dotIterator = this.warningSelectionDots.iterator();
                Iterator markIterator = this.warningSelectionMarks.iterator();
                for (int ctr2 = 0; ctr2 < end; ++ctr2) {
                    ((HighlightedDocument.Position)dotIterator.next()).setOffset(this.currentWarnings.selectionStart[ctr2]);
                    ((HighlightedDocument.Position)markIterator.next()).setOffset(this.currentWarnings.selectionEnd[ctr2]);
                }
                if (dotIterator.hasNext()) {
                    ((HighlightedDocument.Position)dotIterator.next()).setOffset(0);
                    ((HighlightedDocument.Position)markIterator.next()).setOffset(0);
                }
            }
            if (this.warningSelectionDots.size() < length) {
                this.warningSelectionDots.ensureCapacity(length);
                this.warningSelectionMarks.ensureCapacity(length);
                for (ctr = this.warningSelectionDots.size(); ctr < length; ++ctr) {
                    this.warningSelectionDots.add(this.program.createPosition(this.currentWarnings.selectionStart[ctr]));
                    this.warningSelectionMarks.add(this.program.createPosition(this.currentWarnings.selectionEnd[ctr]));
                }
            }
            if (this.warningTallyList.getModel() instanceof DefaultListModel) {
                model = (DefaultListModel)this.warningTallyList.getModel();
                if (model.size() > 1) {
                    model.clear();
                }
            } else {
                model = new DefaultListModel();
                this.warningTallyList.setModel(model);
            }
            int elapsedTime = (int)(System.currentTimeMillis() - startTime);
            String string = "Syntax check complete: " + (length - (this.hasFatalError ? 1 : 0)) + " warning(s), " + (this.hasFatalError ? 1 : 0) + " error(s), " + elapsedTime / 1000 + "." + elapsedTime % 1000 / 10 + " ms.";
            if (model.size() == 0) {
                model.addElement(string);
            } else {
                model.set(0, string);
            }
            if (((Boolean)extraInfo).booleanValue() && this.leftEditPane.getDividerLocation() >= this.leftEditPane.getMaximumDividerLocation()) {
                this.leftEditPane.setDividerLocation(0.8);
            }
            return true;
        }
        if (command == FUNCTION_COMMAND) {
            int selectionStart = this.editTextArea.getSelectionStart();
            int selectionEnd = this.editTextArea.getSelectionEnd();
            this.program.replace(selectionStart, selectionEnd - selectionStart, "function Unnamed\n// Input:               \n// Return address:      \n// Output:              \n// Temporary variables: ", false);
            this.editTextArea.select(selectionStart + 9, selectionStart + 16, selectionStart + 16);
            return true;
        }
        if (command == LOAD_COMMAND) {
            if (this.virtualMachine.isRunning()) {
                return false;
            }
            TWord addr = this.simMachinePane.getAddr();
            this.virtualMachine.setProgramCtr(addr);
            this.virtualMachine.setMem(addr.getValue(), this.simMachinePane.getData());
            this.simMemPane.scrollToPc();
            return true;
        }
        if (command == LOOK_COMMAND) {
            if (this.virtualMachine.isRunning()) {
                return false;
            }
            this.virtualMachine.setProgramCtr(this.simMachinePane.getAddr());
            this.simMemPane.scrollToPc();
            return true;
        }
        if (command == STEP_COMMAND) {
            long startTime = System.currentTimeMillis();
            this.stepsTaken += this.virtualMachine.step();
            if (this.mode == DEBUG_MODE_COMMAND) {
                this.elapsedTime += (int)(System.currentTimeMillis() - startTime);
                if (this.virtualMachine.needsInput()) {
                    this.rightDebugPane.setSelectedComponent(this.debugStdinPane);
                } else if (this.virtualMachine.hasEncounteredError()) {
                    this.rightDebugPane.setSelectedComponent(this.debugStdoutPane);
                }
                this.stepsTakenTextField.setText(String.valueOf(this.stepsTaken));
                int elapsedTimeSec = this.elapsedTime / 1000;
                int elapsedTimeRem = this.elapsedTime % 1000;
                if (elapsedTimeRem >= 100) {
                    this.elapsedTimeTextField.setText(elapsedTimeSec + "." + elapsedTimeRem + " s");
                } else if (elapsedTimeRem >= 100) {
                    this.elapsedTimeTextField.setText(elapsedTimeSec + ".0" + elapsedTimeRem + " s");
                } else {
                    this.elapsedTimeTextField.setText(elapsedTimeSec + ".00" + elapsedTimeRem + " s");
                }
            } else {
                this.simMemPane.scrollToPc();
            }
            return true;
        }
        if (command == RUN_COMMAND) {
            this.virtualMachine.run(this);
            return true;
        }
        if (command == ENTER_COMMAND) {
            if (this.virtualMachine.isRunning()) {
                return false;
            }
            TWord data = this.simMachinePane.getData();
            this.virtualMachine.getUnconsumedStdin(this.tempBuffer);
            this.tempBuffer.add(data);
            this.virtualMachine.setStdin(null, this.tempBuffer);
            return true;
        }
        if (command == INTERRUPT_COMMAND) {
            this.virtualMachine.interrupt();
            return true;
        }
        if (command == RESET_COMMAND) {
            if (this.virtualMachine.isRunning()) {
                return false;
            }
            this.program.reset(this.virtualMachine);
            if (this.mode == DEBUG_MODE_COMMAND) {
                Object data = this.odometerLock;
                synchronized (data) {
                    this.stepsTaken = 0;
                    this.elapsedTime = 0;
                    this.stepsTakenTextField.setText("0");
                    this.elapsedTimeTextField.setText("0.000 s");
                }
            } else if (this.mode == SIM_MODE_COMMAND) {
                this.simStdinPane.scrollToFrontier(true);
            }
            return true;
        }
        if (command == OPEN_STDIN_COMMAND) {
            JFileChooser chooser = new JFileChooser();
            File currentDirectory = TOptionsFrame.getCurrentDirectory();
            if (currentDirectory != null) {
                chooser.setCurrentDirectory(currentDirectory);
            }
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.addChoosableFileFilter(TXT_FILE_FILTER);
            chooser.setFileHidingEnabled(true);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showOpenDialog(this) != 0) {
                return false;
            }
            currentDirectory = chooser.getCurrentDirectory();
            if (currentDirectory != null) {
                TOptionsFrame.setCurrentDirectory(currentDirectory);
            }
            File file = chooser.getSelectedFile();
            StringBuffer buffer = new StringBuffer();
            try {
                int readChars;
                FileReader fileReader = new FileReader(file);
                char[] array = new char[100];
                do {
                    if ((readChars = fileReader.read(array, 0, array.length)) == -1) continue;
                    buffer.append(array, 0, readChars);
                } while (readChars != -1);
                fileReader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred when reading from the file \"" + file + "\".", "File I/O Error", 0);
                return false;
            }
            TWordBuffer unconsumedStdin = this.virtualMachine.getUnconsumedStdin();
            int length = buffer.length();
            int charCtr = 0;
            while (charCtr < length) {
                char ch = buffer.charAt(charCtr);
                if (TWord.isHexDigit(ch)) {
                    int peekCtr;
                    for (peekCtr = charCtr + 1; peekCtr < length && peekCtr < charCtr + 4 && TWord.isHexDigit(buffer.charAt(peekCtr)); ++peekCtr) {
                    }
                    try {
                        unconsumedStdin.add(TWord.parseWord(buffer.substring(charCtr, peekCtr), 16));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    charCtr = peekCtr;
                    continue;
                }
                ++charCtr;
            }
            this.virtualMachine.setStdin(null, unconsumedStdin);
            return true;
        }
        if (command == SAVE_STDIN_COMMAND) {
            int ctr;
            int result;
            File file;
            JFileChooser chooser = new JFileChooser();
            File currentDirectory = TOptionsFrame.getCurrentDirectory();
            if (currentDirectory != null) {
                chooser.setCurrentDirectory(currentDirectory);
            }
            chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), "toy_stdin.txt"));
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.addChoosableFileFilter(TXT_FILE_FILTER);
            chooser.setFileHidingEnabled(true);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showSaveDialog(this) != 0) {
                return false;
            }
            currentDirectory = chooser.getCurrentDirectory();
            if (currentDirectory != null) {
                TOptionsFrame.setCurrentDirectory(currentDirectory);
            }
            if ((file = chooser.getSelectedFile()).exists() && (result = JOptionPane.showConfirmDialog(this, "The file \"" + file + "\" already exists.\n" + "Are you sure you want to save over it?", "Confirm Save As Command", 0, 2)) != 0) {
                return false;
            }
            TWordBuffer stdin = this.virtualMachine.getConsumedStdin();
            StringBuffer buffer = new StringBuffer();
            int size = stdin.getSize();
            for (ctr = 0; ctr < size; ++ctr) {
                buffer.append(stdin.getWord(ctr).toHexString(false));
                buffer.append('\n');
            }
            this.virtualMachine.getUnconsumedStdin(stdin);
            size = stdin.getSize();
            for (ctr = 0; ctr < size; ++ctr) {
                buffer.append(stdin.getWord(ctr).toHexString(false));
                buffer.append('\n');
            }
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(buffer.toString());
                fileWriter.close();
            }
            catch (Exception e) {
                file = null;
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred when writing to the file \"" + file + "\".", "File I/O error", 0);
            }
            return true;
        }
        if (command == SAVE_STDOUT_COMMAND) {
            int result;
            File file;
            JFileChooser chooser = new JFileChooser();
            File currentDirectory = TOptionsFrame.getCurrentDirectory();
            if (currentDirectory != null) {
                chooser.setCurrentDirectory(currentDirectory);
            }
            chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), "toy_stdout.txt"));
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.addChoosableFileFilter(TXT_FILE_FILTER);
            chooser.setFileHidingEnabled(true);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showSaveDialog(this) != 0) {
                return false;
            }
            currentDirectory = chooser.getCurrentDirectory();
            if (currentDirectory != null) {
                TOptionsFrame.setCurrentDirectory(currentDirectory);
            }
            if ((file = chooser.getSelectedFile()).exists() && (result = JOptionPane.showConfirmDialog(this, "The file \"" + file + "\" already exists.\n" + "Are you sure you want to save over it?", "Confirm Save As Command", 0, 2)) != 0) {
                return false;
            }
            TWordBuffer stdout = this.virtualMachine.getStdout();
            StringBuffer buffer = new StringBuffer();
            int size = stdout.getSize();
            for (int ctr = 0; ctr < size; ++ctr) {
                buffer.append(stdout.getWord(ctr).toHexString(false));
                buffer.append('\n');
            }
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(buffer.toString());
                fileWriter.close();
            }
            catch (Exception e) {
                file = null;
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred when writing to the file \"" + file + "\".", "File I/O error", 0);
            }
            return true;
        }
        if (command == SAVE_CORE_DUMP_COMMAND) {
            int result;
            File file;
            JFileChooser chooser = new JFileChooser();
            File currentDirectory = TOptionsFrame.getCurrentDirectory();
            if (currentDirectory != null) {
                chooser.setCurrentDirectory(currentDirectory);
            }
            chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), "toy_core.txt"));
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.addChoosableFileFilter(TXT_FILE_FILTER);
            chooser.setFileHidingEnabled(true);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showSaveDialog(this) != 0) {
                return false;
            }
            currentDirectory = chooser.getCurrentDirectory();
            if (currentDirectory != null) {
                TOptionsFrame.setCurrentDirectory(currentDirectory);
            }
            if ((file = chooser.getSelectedFile()).exists() && (result = JOptionPane.showConfirmDialog(this, "The file \"" + file + "\" already exists.\n" + "Are you sure you want to save over it?", "Confirm Save As Command", 0, 2)) != 0) {
                return false;
            }
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this.virtualMachine.getCoreDump());
                fileWriter.close();
            }
            catch (Exception e) {
                file = null;
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred when writing to the file \"" + file + "\".", "File I/O error", 0);
            }
            return true;
        }
        if (command == SAVE_MEM_DUMP_COMMAND) {
            int result;
            File file;
            JFileChooser chooser = new JFileChooser();
            File currentDirectory = TOptionsFrame.getCurrentDirectory();
            if (currentDirectory != null) {
                chooser.setCurrentDirectory(currentDirectory);
            }
            chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), "toy_memory.txt"));
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.addChoosableFileFilter(TXT_FILE_FILTER);
            chooser.setFileHidingEnabled(true);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            if (chooser.showSaveDialog(this) != 0) {
                return false;
            }
            currentDirectory = chooser.getCurrentDirectory();
            if (currentDirectory != null) {
                TOptionsFrame.setCurrentDirectory(currentDirectory);
            }
            if ((file = chooser.getSelectedFile()).exists() && (result = JOptionPane.showConfirmDialog(this, "The file \"" + file + "\" already exists.\n" + "Are you sure you want to save over it?", "Confirm Save As Command", 0, 2)) != 0) {
                return false;
            }
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this.virtualMachine.getMemDump());
                fileWriter.close();
            }
            catch (Exception e) {
                file = null;
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred when writing to the file \"" + file + "\".", "File I/O error", 0);
            }
            return true;
        }
        if (command == CHANGE_EXECUTION_COMMAND) {
            TOptionsFrame.show(TOptionsFrame.EXECUTION_PERFORMANCE_NODE);
            return true;
        }
        if (command == CLEAR_ODOMETER_COMMAND) {
            Object object = this.odometerLock;
            synchronized (object) {
                this.stepsTaken = 0;
                this.elapsedTime = 0;
                this.stepsTakenTextField.setText("0");
                this.elapsedTimeTextField.setText("0.000 s");
            }
            return true;
        }
        if (command == CHANGE_CHECKING_COMMAND) {
            TOptionsFrame.show(TOptionsFrame.EDITING_CHECKING_NODE);
            return true;
        }
        if (command == HIDE_WARNINGS_COMMAND) {
            this.leftEditPane.setDividerLocation(1.0);
            return true;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == WORKSPACE_COMMAND) {
            this.doCommand(WORKSPACE_COMMAND, ((WorkspaceMenuItem)e.getSource()).getIndex());
        } else if (e.getActionCommand() == CHECK_SYNTAX_COMMAND) {
            this.doCommand(CHECK_SYNTAX_COMMAND, Boolean.TRUE);
        } else {
            this.doCommand(e.getActionCommand(), null);
        }
    }

    @Override
    public void textValueChanged(TextEvent e) {
        this.updateTitle();
        this.programChanged = true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selectedIndex = this.warningList.getSelectedIndex();
        if (selectedIndex != -1) {
            this.editTextArea.select(((HighlightedDocument.Position)this.warningSelectionDots.get(selectedIndex)).getOffset(), ((HighlightedDocument.Position)this.warningSelectionMarks.get(selectedIndex)).getOffset());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        boolean editMode = this.mode == EDIT_MODE_COMMAND;
        boolean simMode = this.mode == SIM_MODE_COMMAND;
        boolean isRunning = this.virtualMachine.isRunning();
        boolean canGo = !isRunning && !this.virtualMachine.isDone() && !this.virtualMachine.needsInput();
        this.editModeAction.setEnabled(!isRunning);
        this.debugModeAction.setEnabled(!isRunning);
        this.simModeAction.setEnabled(!isRunning);
        this.lookAction.setEnabled(simMode && !isRunning);
        this.loadAction.setEnabled(simMode && !isRunning);
        this.enterAction.setEnabled(simMode && !isRunning);
        this.resetAction.setEnabled(!editMode && !isRunning);
        this.stepAction.setEnabled(!editMode && canGo);
        this.runAction.setEnabled(!editMode && canGo);
        this.interruptAction.setEnabled(!editMode && isRunning);
        this.openStdinAction.setEnabled(!isRunning);
        this.saveStdinAction.setEnabled(!isRunning);
        this.saveStdoutAction.setEnabled(!editMode && !isRunning);
        this.saveMemDumpAction.setEnabled(!editMode && !isRunning);
        this.saveCoreDumpAction.setEnabled(!editMode && !isRunning);
        if (this.mode == DEBUG_MODE_COMMAND) {
            int lineDefined = this.program.getLineDefined(this.virtualMachine.getProgramCtr().getValue() & 0xFF, true);
            if (this.debugTextArea.getHighlightedLine() != lineDefined) {
                this.debugTextArea.setHighlightedLine(lineDefined);
                this.debugTextArea.scrollToCaret();
            }
        }
    }

    @Override
    public int statusUpdate(TVirtualMachine virtualMachine, int n, int elapsedTime, boolean willStop) {
        if (this.mode == DEBUG_MODE_COMMAND) {
            this.stepsTaken += n;
            this.elapsedTime += elapsedTime;
            if (virtualMachine.needsInput()) {
                this.rightDebugPane.setSelectedComponent(this.debugStdinPane);
            } else if (virtualMachine.hasEncounteredError()) {
                this.rightDebugPane.setSelectedComponent(this.debugStdoutPane);
            }
            this.stepsTakenTextField.setText(String.valueOf(this.stepsTaken));
            int elapsedTimeSec = this.elapsedTime / 1000;
            int elapsedTimeRem = this.elapsedTime % 1000;
            if (elapsedTimeRem >= 100) {
                this.elapsedTimeTextField.setText(elapsedTimeSec + "." + elapsedTimeRem + " s");
            } else if (elapsedTimeRem >= 10) {
                this.elapsedTimeTextField.setText(elapsedTimeSec + ".0" + elapsedTimeRem + " s");
            } else {
                this.elapsedTimeTextField.setText(elapsedTimeSec + ".00" + elapsedTimeRem + " s");
            }
        } else {
            this.simMemPane.scrollToPc();
        }
        return TOptionsFrame.getRefreshRate();
    }

    @Override
    public int getClockPeriod() {
        return TOptionsFrame.getClockPeriod();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.doCommand(CLOSE_COMMAND, null);
        }
        super.processWindowEvent(e);
    }

    static /* synthetic */ Object[] access$102(Object[] x0) {
        FRAMES_ARRAY = x0;
        return x0;
    }

    protected static class Runner
    implements Runnable {
        protected Thread runningThread;

        protected Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            while (this.runningThread == currentThread) {
                List list = FRAMES;
                synchronized (list) {
                    int length = FRAMES.size();
                    TFrame.access$102(FRAMES.toArray(FRAMES_ARRAY));
                    Object[] framesArray = FRAMES_ARRAY;
                    for (int ctr = 0; this.runningThread == currentThread && ctr < length; ++ctr) {
                        TFrame frame = (TFrame)framesArray[ctr];
                        if (!frame.programChanged) continue;
                        frame.doCommand(CHECK_SYNTAX_COMMAND, Boolean.FALSE);
                    }
                }
                if (this.runningThread != currentThread) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.runningThread = null;
                    e.printStackTrace();
                }
            }
        }
    }

    public static class WorkspaceMenuItem
    extends JRadioButtonMenuItem {
        private Integer index;

        public WorkspaceMenuItem(int index) {
            this.index = new Integer(index);
        }

        public Integer getIndex() {
            return this.index;
        }
    }

    protected class TFrameAction
    extends AbstractAction2 {
        protected TFrameAction(String name, Icon icon, int mnemonic, KeyStroke accelerator, String command) {
            this(name, icon, mnemonic, accelerator, command, null);
        }

        protected TFrameAction(String name, Icon icon, int mnemonic, KeyStroke accelerator, String command, Object extraInfo) {
            super(name, icon);
            if (name == null || command == null) {
                throw new NullPointerException();
            }
            this.setMnemonic(mnemonic);
            this.setAccelerator(accelerator);
            this.setActionCommand(command);
            this.setExtraInfo(extraInfo);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TFrame.this.doCommand(this.getActionCommand(), this.getExtraInfo());
        }
    }
}

